//****************************************************************
//   The Basic Bass Model: System Version 1.1
//   Using analogous products parameters:    Simulation Model
//     AUTHOR  Shigeru Kido      
//     Scilab-5.4.1 
//     Mac OS-X version 10.8.4 
//     THE PROGRAM NAME : Basic_Bass_Model_for_Mac8.sce
//     Apple menu-bar version
//     Update:  August 27. 2013 
//****************************************************************
//:----------- Initialize :--------------------------------------
clear ;        //clear  work space
delmenu('BassModel'); 
//clc();         //clear  commad window
//clear current graph,reset default value
 for k=1:12;clf(k);end;     
// scf(0);
//delmenu('TaskMenu');     
Num=0;
//:-------------------------------------------------------------  
//:---------------------------------------------------------
function [pqm,p,q,m,n,r,Ct,Ctg,Nam]=SetDatat(i)
//note 1) analogous products p & q data set, 13th is average
//note 2) m (potetial market size unit is Millions)
//note 3) n period 
//Data Source: Marketing Engineering, Revised Second Edition(2003)
// by Lilien and Rangaswamy. (p.259)  
//_ p______ q_______m _______ n____
pqm3=[
0.100	0.060	68.000	13.000
0.044	0.304	30.500	10.000
0.008	0.421	45.100	10.000
0.550	0.378	29.600	10.000
0.027	0.435  100.000	12.000
0.121	0.281	25.800   6.000
0.013	0.455	92.200	16.000
0.036	0.268	95.000	19.000
0.044	0.350	57.900	13.000
0.006	0.185	60.500	29.000
0.002	0.357	91.600	18.000
0.025	0.603	76.300	13.000
0.081	0.341	64.375	14.083
];
//_ p _____ q _____ m _______ n ______ p/q_ratio _
//pqm2=[
//0.100	0.060	68.000	13.000	1.666666667	Cable_TV
//0.044	0.304	30.500	10.000	0.144736842	Camcorder 
//0.008	0.421	45.100	10.000	0.019002375	Cellular_phone
//0.550	0.378	29.600	10.000	1.455026455	CD_Player
//0.027	0.435    100.000    12.000	0.062068966	Radio
//0.121	0.281	25.800      6.000	0.430604982	Home_PC
//0.013	0.455	92.200	16.000	0.028571429	Bale_hay
//0.036	0.268	95.000	19.000	0.134328358	CT_scan_100+
//0.044	0.350	57.900	13.000	0.125714286	CT_scan_99beds
//0.006	0.185	60.500	29.000	0.032432432	Room_Air_Con
//0.002	0.357	91.600	18.000	0.005602241	Microwave
//0.025	0.603	76.300	13.000	0.041459370	VCR 
//0.081	0.341	64.375	14.083	0.238223090	Average
//];
//
// p ___ q ______ m _____ n ____ q/p_ratio _product
pqm =[
0.100	0.060	68.000	13.000	0.600   // 1 Cable_TV
0.044	0.304	30.500	10.000	6.909   // 2 Camcorder 
0.008	0.421	45.100	10.000	52.625  // 3 Cellular_phone
0.550	0.378	29.600	10.000	0.687   // 4 CD_Player
0.027	0.435	100.000	12.000	16.111  // 5 Radio
0.121	0.281	25.800	6.000	2.322   // 6 Home_PC
0.013	0.455	92.200	16.000	35.000  // 7 Bale_hay
0.036	0.268	95.000	19.000	7.444   // 8 CT_scan_100+
0.044	0.350	57.900	13.000	7.955   // 9 CT_scan-99beds
0.006	0.185	60.500	29.000	30.833  // 10 Room_Air_Con
0.002	0.357	91.600	18.000	178.500 // 11 Microwave
0.025	0.603	76.300	13.000	24.120  // 12 VCR 
0.081	0.341	64.375	14.083	4.198   // 13 Average
];

//
// for for-loop-index
p=pqm(i,1);
q=pqm(i,2);
m=pqm(i,3);
n=pqm(i,4);
r=pqm(i,5);
//n=10;
//analogous products category labels
Ctg=['(1)Cable_TV','(2)Camcorder','(3)Cell_Phone','(4)CD_Player',...
     '(5)Radio','(6)Home_PC','(7)Bale_hay','(8)CT 100+beds',...
     '(9)CT -99 beds','(10)Room_AirCon','(11)Microwave','(12)VCR',...
     '(13)Average','My Product'];
Ct(i)=Ctg(i)';
Nam= Ctg(i) ; 
endfunction 
//
//:------------------------------------------------------  
function Disp_Title()
// Display title
//:------------------------------------------------------   
 w=getdate()
mprintf('                               Date: %d, %d/%d  \n',w(1),w(2),w(6));
mprintf(' _/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/\n');
mprintf(' _/_/_/_/_/           The Basic Bass Model           　_/_/_/_/_/\n');  
mprintf(' _/           Using analogous products parameters              _/\n');
mprintf(' _/             Scilab-5.4.1                                   _/\n');
mprintf(' _/             Mac OS X  version 10.8.4                       _/\n');
mprintf(' _/             Author  :  S. Kido                             _/\n');
mprintf(' _/             Update  :  August 27, 2013                     _/\n');
mprintf(' _/             Program Name : Basic_Bass_Model_for_Mac8.sce   _/\n');
mprintf(' _/             Apple Menu Bar Version 1.2                     _/\n');
mprintf(' _/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/\n');
mprintf('\n');  
mprintf('* Please make active console window then choose a task from [BassModel] on Apple Menu-Bar \n');
endfunction 
//
//:----------------------------------------------------------------------
function  [p,q,m,n,Num,Nam]=SelectModelNum(pqm,Ctg)
// select  analogous products number then display parameters
//:----------------------------------------------------------------------
delete(gca()); // clear window 
Title=[' BASS MODEL:  analogous products parameters choice method';'   ';
'Select Analogous Products Number(1-12)'];
Def=[''];
Num=evstr(x_dialog(Title,Def));
p=pqm(Num,1);
q=pqm(Num,2);
m=pqm(Num,3);
n=pqm(Num,4);
Nam=Ctg(Num);
//
Disp_Model_Param(p,q,m,n,Ct,Ctg,Num,Nam) ;
[a1,a2,a3,a4]=CompBass(p,q,m,n);
Disp_Results(a1,a2,a3,a4,Ct,Ctg,Num,Nam);
 PlotGraphs3(n,a1,a2,a3,a4,Nam);
endfunction
//
//:--------------------------------------------------------
function [p,q,m,n,Nam,Num]=GUI_input_param(Num)
//   GUI input: Edit parameters: p, q, m, n, Nam 
//:--------------------------------------------------------
//
 ttl = ['Basic Bass Model : Using analogous products parameters'];
 txt = ['External/ innovation Coefficient : p';...
        'Internal/ imitation  Coefficient : q';...
        'Market potential Pop.(unit:1000) : m';...
        'Estimating Time (period:years)   : n';...
        'Product/ Service Name            :  '];
 def = ['0.01';'0.41';'160';'24';' A1'];
 //      0.081   0.341   64.375	14.083	Average
BassParam = x_mdialog(ttl,txt,def);
p1 = evstr(BassParam(1))
q1 = evstr(BassParam(2))
m1 = evstr(BassParam(3))
n1 = evstr(BassParam(4))
Nam = BassParam(5)
//
p=p1;q=q1;m=m1;n=n1;
//Num=14;
//Ctg(14)=Nam;// replace new product name from "My product" 
Disp_Model_Param(p,q,m,n,Ct,Ctg,Num,Nam) ;
[a1,a2,a3,a4]=CompBass(p,q,m,n);
Disp_Results(a1,a2,a3,a4,Ct,Ctg,Num,Nam);
Plot_Graphs(n,a1,a2,a3,a4,Nam);
endfunction  
//
//:---------------------------------------------------------
function [a1,a2,a3,a4]=CompBass(p,q,m,n)
//   Compute Basic Bass Model
//    cumAtm1 is cumulative adoptions at t-1,
//  a(t) = p * m + (q - p) * cumAtm1 - (q / m) * (cumAtm1 ^ 2)
//:--------------------------------------------------------
     cumAtm1=0;
     a1=[];
     a2=[];
     a3=[];
     a4=[];
     for  t=1:n;
       a1(t) = p * m + (q - p) * cumAtm1 - (q / m) * (cumAtm1 ^ 2);
            cumAtm1=cumAtm1+a1(t);
            a2(t)=cumAtm1;
            a3(t)=100*(cumAtm1)/m;
            a4(t)=100*a1(t)/m; // % rate: a4(t)=100*a1(t)/cumAtm1   
     end ;  
endfunction
//
//:--------------------------------------------------------
function Disp_Model_Param(p,q,m,n,Ct,Ctg,Num,Nam)  
//  Display parameters of current model
//:--------------------------------------------------------
r=q/p;   // q/p ratio
// Tstar= (-1/(p+q))*log(p/q);     // peak time T*
//Tstar= (log(q)-log(p))/(p+q);  // peak time
//cumFTstr=(1/2)-(p/2*q)           // cumlative adopter at time T*
//fstr=(1/4*q)*(p+q)^2             //noncumlative adopter at time T*
//
 mprintf('\n\n');
mprintf('=======  Parameters of Product: %10s     ======= \n',Nam );
     mprintf('  External(innovation) effects  p :  %7.4f \n', p);
     mprintf('  Internal(imitation ) effects  q :  %7.4f \n', q);
     mprintf('  Internal / External  ratio  q/p :  %7.4f \n', r);
     mprintf('            Market potential    m :  %7.1d \n', m);
     mprintf('            Time (period)       n :  %7d   \n', n);
mprintf('--------------------------------------------------------\n\n\n');   
//     mprintf('  Peak Time (period)           T* :  %7d \n', Tstar); 
//     mprintf('  Peak Time Cum. adopters    F(T*):  %7.4f \n', cumFTstr); 
//     mprintf('  Peak Time Adopters         f(T*):  %7.4f \n', fstr); 
 mprintf('\n\n');  
endfunction
//:--------------------------------------------------------  
function Disp_Results(a1,a2,a3,a4,Ct,Ctg,Num,Nam)
// Display Summary of Results
//:--------------------------------------------------------
mprintf('=========   Bass Model: Summary of Results     ========= \n');
mprintf('-----------  Product: %10s        -------------- \n',Nam);                             
mprintf(' TIME   Sales      Cum.Sales     Rate(%%)   Cum.Rate(%%)   \n');
  for I=1:n;
mprintf('%3d  %10.3f  %10.3f    %7.1f    %7.1f\n',...
          I, a1(I),a2(I),a4(I),a3(I)); 
  end
mprintf('-------------------------------------------------------\n\n');
endfunction
//
//:--------------------------------------------------------
function  Plot_Graphs(n,a1,a2,a3,a4,Nam)
// Plot graphs
//:--------------------------------------------------------  
 [a1,a2,a3,a4]=CompBass(p,q,m,n) ;
//
dt =1;
t = 1 : dt : n;
t = t';
//
scf(1); //
subplot(2,1,1);
plot2d(t,a2)  
xtitle ('  Bass Model::::::: Cum. Sales ',...
        'Time Period (year)');
xgrid();
// location(coodinate) of product name on the graph
x1 =2;
y1 =a2(round(n/2));
// locate the name at mid-point of vertical scale
xstring(x1,y1,Nam);
//
subplot(2,1,2);
plot2d(t,a1)
xtitle ('  Bass Model::::: Sales Distribution',...
        'Time Period (year)');
xgrid();
x2=2;
y2=round(a1(4));
xstring(x2,y2,Nam);
//
//open new window for Growth Rate( percentage) graph:
scf(2);
plot2d(t,[a3,a4],style=[color('black'),color('red')]);
xtitle ('Bass Model:::::Growth Rate(%) & Cum.Growth Rate(%)',...
        'Time Period (year)');
xgrid();
// location(coodinate) of product name on the graph
// locate the name at mid-point of vertical scale
x3 =2;
y3 =round(a4(n)/2) ;
xstring(x3,y3,Nam);
//
endfunction
//
//:--------------------------------------------------------
function  PlotGraphs3(n,a1,a2,a3,a4,Nam)
//  Plot single  graphs
//:--------------------------------------------------------   
dt =1;
t = 1 : dt : n;
t = t';
 scf(3); 
 f3=scf(3); 
 plot2d(t,[a2,a1],style=[color('black'),color('red')]); 
  xtitle (':::: Bass Model::::: Growth  & Cum. Growth  ','Time Period (year)');
xgrid();
x2=2;
y2=round(a1(n));
xstring(x2,y2,Nam);
endfunction
//
//:--------------------------------------------------------
function  PlotGraphs4(n,a1,a2,a3,a4,Ct)
//  Plot selection  graphs
//:--------------------------------------------------------   
dt =1;
t = 1 : dt : n;
t = t';
 scf(0); 
 subplot(3,4,i);
 plot2d(t,[a2,a1],style=[color('black'),color('red')]); 
  xi=2;
 yi=a2(round(n/2 ));
 if i==4 then  yi=16;   end; // for (4)CD_Player
xstring(xi,yi,Ct(i));
endfunction
//
//:--------------------------------------------------------
function  PlotCurrentGraphs(n,a1,a2,a3,a4,Nam)
//  Plot current  graphs
//:--------------------------------------------------------   
dt =1;
t = 1 : dt : n;
t = t';
 scf(4); 
 plot2d(t,[a2,a1 ],style=[color('black'),color('red')]); 
  xtitle (':::: Current Model::::: Growth  & Cum. Growth  ',...
          'Time Period (year)');
xgrid();
x4=2;
y4=round(a1(n));
xstring(x4,y4,Nam);
endfunction
//
//:-----------------------------------------------------------------------
function ExitSys()
    //  abort this program
     mprintf('(Bye ...!)\n');
  // clf();
   delete(gca()); 
delmenu('TaskMenu');
     abort;
endfunction
//:-----------------------------------------------------------------------
// Apple menu version 1.1
//:********************************
//:*******   Main Program   *******
//:********************************  
//
//titlepage("The Basic Bass Model: System Version 1.1");
//
 Disp_Title();
 n1 =13;
  for i=1:n1 // create 12 product-categories graphic selection menu
      [pqm,p,q,m,n,r,Ct,Ctg,Nam]=SetDatat(i);
      [a1,a2,a3,a4]=CompBass(p,q,m,n);
       PlotGraphs4(n,a1,a2,a3,a4,Ct);
  end
[p,q,m,n,Num,Nam]=SelectModelNum(pqm,Ctg);  
// add menus to console window(0)
//
a1=[];a2=[];a3=[];a4=[];
setmenu(0,'TaskMenu');
 addmenu('BassModel',...
      ['Select Analogous Product';...
       'Edit Parameters';...
       'ExitSys'] );
      BassModel  =['[p,q,m,n,Num,Nam]=SelectModelNum(pqm,Ctg)',...
                   '[p,q,m,n,Nam,Num]=GUI_input_param(Num)',...
                   'ExitSys()'];
////       'Plot Current Product';...
////                   ' PlotCurrentGraphs(n,a1,a2,a3,a4,Nam)',...
//:------- End of Main Program ------------------------------------------------
